<?php
/**
 * Single Product stock.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/stock.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $alpha_stock_progress;

$stock_quantity = $product->get_stock_quantity();

if ( ! $alpha_stock_progress || ! $stock_quantity ) {
	?>
<p class="stock <?php echo esc_attr( $class ); ?>"><?php echo wp_kses_post( $availability ); ?></p>
	<?php
} else {
	$already_sold     = get_post_meta( $product->get_ID(), 'total_sales', true );
	$already_sold     = empty( $already_sold ) ? 0 : $already_sold;
	$all_stock        = $stock_quantity + $already_sold;
	$stock_line_inner = ( ( $stock_quantity * 100 ) / $all_stock );

	if ( $stock_quantity <= get_option( 'woocommerce_notify_low_stock_amount' ) ) {
		$extra_class = ' low-progress';
	} elseif ( $stock_line_inner > 50 ) {
		$extra_class = '';
	} else {
		$extra_class = ' medium-progress';
	}

	?>
	<div class="progress-bars progress-animated percent-end-bar stock">
		<div class="title-wrapper"><span class="title"><?php echo (int) $stock_quantity . esc_html__( ' Available', 'alpha' ); ?></span><span class="progress-percentage"><?php echo (int) $already_sold . esc_html__( ' Sold', 'alpha' ); ?></span></div>
		<div class="progress-wrapper stock-progress<?php echo esc_attr( $extra_class ); ?>" data-value="<?php echo esc_attr( $stock_line_inner ); ?>"><div class="progress-bar"></div></div>
	</div>
	<?php
}
