<?php
/**
 * Alpha WooCommerce Archive Product Functions
 *
 * Functions used to display archive product.
 *
 * @author     Andon
 * @package    Alpha Framework
 * @subpackage Theme
 * @since      4.0
 */

defined( 'ABSPATH' ) || die;

/**
 * Alpha shop page show type
 *
 * @since 4.0
 */
if ( ! function_exists( 'alpha_wc_shop_show_type' ) ) {
	function alpha_wc_shop_show_type() {
		$mode = 'grid';
		if ( ! empty( $_REQUEST['showtype'] ) ) {
			$mode = $_REQUEST['showtype'];
		}
		$base_link = remove_query_arg( 'paged', remove_query_arg( 'showtype' ) );
		$grid_url  = add_query_arg( 'showtype', 'grid', $base_link );
		$list_url  = add_query_arg( 'showtype', 'list', $base_link );
		?>
		<div class="toolbox-item toolbox-show-type">
			<a href="<?php echo esc_url( $base_link ); ?>" class="<?php echo ALPHA_ICON_PREFIX; ?>-icon-grid btn-showtype mode-grid<?php echo 'grid' == $mode ? ' active' : ''; ?>" aria-label="<?php esc_attr_e( 'Grid Layout', 'alpha' ); ?>"></a>
			<a href="<?php echo esc_url( $list_url ); ?>" class="<?php echo ALPHA_ICON_PREFIX; ?>-icon-list btn-showtype mode-list<?php echo 'list' == $mode ? ' active' : ''; ?>" aria-label="<?php esc_attr_e( 'List Layout', 'alpha' ); ?>"></a>
		</div>
		<?php
		do_action( 'alpha_wc_archive_after_toolbox' );
	}
}
