<?php
/**
 * Backwards Compatiblity Class
 *
 * Functions include compatibility codes older than function name versions
 *
 * @author     Andon
 * @package    Alpha FrameWork
 * @subpackage Theme
 * @since      4.12.0
 */
defined( 'ABSPATH' ) || die;

class Alpha_Backwards extends Alpha_Base {

	public $current_theme_version;

	/**
	 * Constructor
	 *
	 * @since 4.12.0
	 * @access public
	 */
	public function __construct() {
		$this->current_theme_version = get_theme_mod( 'theme_version' );

		add_action(
			'init',
			function() {
				$this->version_4_1_0();
				$this->version_4_5_0();
				$this->version_4_12_0();
				$this->all_versions();
			}
		);

		if ( get_option( ALPHA_NAME . '_disable_brand', false ) ) {
			alpha_remove_feature( 'fs_addon_product_brand' );
		}
	}

	public function all_versions() {
		if ( version_compare( $this->current_theme_version, ALPHA_VERSION, '>=' ) ) {
			return;
		}

		set_theme_mod( 'theme_version', ALPHA_VERSION );

		if ( ! $this->current_theme_version ) {
			set_theme_mod( 'resource_disable_fontawesome', true );
			update_option( ALPHA_NAME . '_disable_brand', true );
		}

		if ( class_exists( 'Alpha_Admin' ) && Alpha_Admin::get_instance()->is_registered() ) {
			delete_site_transient( 'alpha_plugins' );
		}
	}

	public function version_4_1_0() {
		// Compatiblity registration of other themes based on framework
		$option = get_option( 'alpha_registered', -1 );
		if ( -1 != $option ) {
			update_option( ALPHA_NAME . '_registered', $option );
			delete_option( 'alpha_registered' );
		}
	}

	public function version_4_5_0() {
		if ( version_compare( $this->current_theme_version, '4.5', '>' ) ) {
			return;
		}

		// Layout builder compatibility
		$conditions = get_theme_mod( 'conditions' );

		if ( is_array( $conditions ) ) {
			foreach ( $conditions as $key => $layout_group ) {
				foreach ( $layout_group as &$layout ) {
					if ( empty( $layout['options']['archive_block'] ) && ! empty( $layout['options']['archive_content'] ) ) {
						$layout['options']['archive_block'] = $layout['options']['archive_content'];
						unset( $layout['options']['archive_content'] );
					}
					if ( empty( $layout['options']['single_block'] ) && ! empty( $layout['options']['single_content'] ) ) {
						$layout['options']['single_block'] = $layout['options']['single_content'];
						unset( $layout['options']['single_content'] );
					}
					if ( empty( $layout['options']['single_product_block'] ) && ! empty( $layout['options']['single_product_template'] ) ) {
						$layout['options']['single_product_block'] = $layout['options']['single_product_template'];
						unset( $layout['options']['single_product_template'] );
					}
					if ( empty( $layout['options']['shop_block'] ) && ! empty( $layout['options']['shop_layout_template'] ) ) {
						$layout['options']['shop_block'] = $layout['options']['shop_layout_template'];
						unset( $layout['options']['shop_layout_template'] );
					}
				}
				$conditions[ $key ] = $layout_group;
			}
			set_theme_mod( 'conditions', $conditions );
		}
	}

	public function version_4_12_0() {
		if ( version_compare( $this->current_theme_version, '4.12.0', '>=' ) ) {
			return;
		}

		// Elementor compatibility
		if ( defined( 'ELEMENTOR_VERSION' ) ) {
			Elementor\Plugin::$instance->files_manager->clear_cache();
			delete_post_meta_by_key( Elementor\Core\Base\Elements_Iteration_Actions\Assets::ASSETS_META_KEY );
		}

		// Default typo compatibility
		$typo_default      = get_theme_mod( 'typo_default' );
		$typo_default_size = get_theme_mod( 'typo_default_size' );

		if ( ! $typo_default_size || ! is_array( $typo_default_size ) ) {
			$typo_default_size = array(
				'desktop'      => isset( $typo_default['font-size'] ) ? $typo_default['font-size'] : '14px',
				'laptop'       => '',
				'tablet_extra' => '',
				'tablet'       => '',
				'mobile'       => '',
			);
		}

		if ( empty( $typo_default_size['desktop'] ) ) {
			$typo_default_size['desktop'] = isset( $typo_default['font-size'] ) ? $typo_default['font-size'] : '14px';
		}

		set_theme_mod( 'typo_default_size', $typo_default_size );

		if ( isset( $typo_default['font-size'] ) ) {
			unset( $typo_default['font-size'] );
			set_theme_mod( 'typo_default', $typo_default );
		}
	}
}

Alpha_Backwards::get_instance();
