<?php
/**
 * WPML Compatibility
 *
 * @author     D-THEMES
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      1.3
 */

if ( ! class_exists( 'Alpha_Wpml' ) ) {

	/**
	 * Alpha WPML Class
	 */
	class Alpha_Wpml extends Alpha_Base {

		/**
		 * The active language
		 */
		private static $active_language = '';

		/**
		 * Is the site using WPML?
		 */
		private static $is_wpml = false;

		/**
		 * Is the site using PolyLang?
		 */
		private static $is_pll = false;

		/**
		 * Main Class construct
		 *
		 * @since 1.3
		 */
		public function __construct() {
			self::$is_pll  = self::is_pll();
			self::$is_wpml = self::is_wpml();

			if ( self::$is_wpml ) {
				if ( alpha_doing_ajax() && isset( $_REQUEST['action'] ) && 'alpha_load_mobile_menu' == $_REQUEST['action'] ) {
					add_filter( 'wpml_ls_enable_ajax_navigation', '__return_true' );
				}

				add_filter( 'alpha_mobile_menu_html', array( $this, 'add_language_flag_html' ) );
			}

			if ( defined( 'WCML_VERSION' ) ) {
				add_filter( 'wcml_multi_currency_ajax_actions', array( $this, 'ajax_actions' ), 10, 1 );
			}

			// localize script
			if ( self::$is_pll || self::$is_wpml ) {
				add_filter( 'alpha_vars', array( $this, 'set_language_vars' ) );
			}
		}

		/**
		 * Add active language flags
		 *
		 * @since 1.3
		 */
		function add_language_flag_html( $html ) {

			$active_languages = apply_filters( 'wpml_active_languages', null, null );

			if ( ! empty( $active_languages ) ) {

				$current_url = '';
				$active_lang = array_filter(
					$active_languages,
					function ( $lang ) {
						return $lang['active'] ? true : false;
					}
				);

				$lang_html = '';

				if ( $active_lang ) {
					$active_lang = $active_lang[ array_keys( $active_lang )[0] ];
					$current_url = $active_lang['url'];

					$sub_langs = '';
					foreach ( $active_languages as $lang ) {
						$url        = str_replace( $current_url, $lang['url'], wp_get_referer() );
						$sub_langs .= '<li><a href="' . esc_url( $url ) . '"><img class="me-1" src="' . esc_url( $lang['country_flag_url'] ) . '" height="12" alt="' . esc_attr( $lang['language_code'] ) . '">' . esc_attr( $lang['translated_name'] ) . '</a></li>';
					}

					ob_start();

					echo '<nav class="flag-menu">';
						echo '<ul class="mobile-menu">';
							echo '<li>';

								echo '<a href="#"><img class="me-1" src="' . esc_url( $active_lang['country_flag_url'] ) . '" height="12" alt="' . esc_attr( $active_lang['language_code'] ) . '">' . esc_attr( $active_lang['translated_name'] ) . '<span class="toggle-btn"></span></a>';

								echo '<ul>';
									echo alpha_strip_script_tags( $sub_langs );
								echo '</ul>';

							echo '</li>';
						echo '</ul>';
					echo '</nav>';

					$lang_html = ob_get_clean();

				}

				if ( $lang_html ) {
					$html = str_replace( '<div class="nav-wrapper">', '<div class="nav-wrapper">' . $lang_html, $html );
				}
			}

			return $html;
		}

		/**
		 * Compatibility with WCML Currency Switcher
		 *
		 * @since 4.11.0
		 */
		public function ajax_actions( $ajax_actions ) {
			$ajax_actions[] = 'alpha_ajax_add_to_cart';
			$ajax_actions[] = 'alpha_quickview';
			$ajax_actions[] = 'alpha_loadmore';
			$ajax_actions[] = 'alpha_cart_item_remove';
			$ajax_actions[] = 'alpha_add_to_cart';
			$ajax_actions[] = 'alpha_update_cart_item';
			$ajax_actions[] = 'remove_from_wishlist';
			$ajax_actions[] = 'alpha_update_mini_wishlist';
			$ajax_actions[] = 'alpha_add_to_compare';
			$ajax_actions[] = 'alpha_remove_from_compare';
			$ajax_actions[] = 'alpha_update_mini_wishlist';

			return $ajax_actions;
		}

		/**
		 * Set language variables
		 *
		 * @since 4.11.3
		 */
		public function set_language_vars( $alpha_vars ) {
			$lang = self::get_active_language();
			if ( $lang ) {
				$alpha_vars['ajax_url']    = esc_url( add_query_arg( 'lang', $lang, admin_url( 'admin-ajax.php' ) ) );
				$alpha_vars['active_lang'] = esc_js( $lang );
			}
			return $alpha_vars;
		}

		/**
		 * Get active language code
		 *
		 * @since 4.11.3
		 */
		public function get_active_language() {
			if ( ! self::$active_language ) {
				if ( ! self::$is_pll && ! self::$is_wpml ) {
					self::$active_language = 'en';
					return self::$active_language;
				}

				if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
					self::$active_language = ICL_LANGUAGE_CODE;
					if ( 'all' === ICL_LANGUAGE_CODE ) {
						if ( self::$is_wpml ) {
							global $sitepress;
							self::$active_language = $sitepress->get_default_language();
						} elseif ( self::$is_pll ) {
							self::$active_language = pll_default_language( 'slug' );
						}
					}
					return self::$active_language;
				}

				if ( function_exists( 'PLL' ) ) {
					$pll_obj = PLL();
					if ( is_object( $pll_obj ) && property_exists( $pll_obj, 'curlang' ) ) {
						if ( is_object( $pll_obj->curlang ) && property_exists( $pll_obj->curlang, 'slug' ) ) {
							self::$active_language = $pll_obj->curlang->slug;
						} elseif ( false === $pll_obj->curlang ) {
							self::$active_language = 'all';
						}
					}
				}
			}
			return self::$active_language;
		}

		/**
		 * Determine if the site is using WPML
		 *
		 * @since 4.11.3
		 */
		public static function is_wpml() {
			return ( ( defined( 'WPML_PLUGIN_FILE' ) || defined( 'ICL_PLUGIN_FILE' ) ) && false === self::$is_pll ) ? true : false;
		}

		/**
		 * Determine if the site is using PolyLang
		 *
		 * @since 4.11.3
		 */
		public static function is_pll() {
			if ( function_exists( 'pll_default_language' ) ) {
				return true;
			}

			return false;
		}
	}
}

Alpha_Wpml::get_instance();
