/**
 * Alpha Theme WPForms JS Library
 * 
 * @author     Andon
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      4.11.0
 * @version    4.11.0
 */
'use strict';

(function ($) {
    // Prevent auto scroll after form submit
    wpforms.scrollToError = function (e) {
        if (0 !== e.length) {
            let t = e.find(".wpforms-field.wpforms-has-error");
            if (0 !== (t = 0 === t.length ? e.closest(".wpforms-field") : t).length && void 0 !== (e = t.offset())) {
                var e = t.find(".wpforms-error").first();
                "function" == typeof e.focus && e.trigger("focus")
            }
        }
    }
    wpforms.printGeneralErrors = function (o, e, i) {
        $.each(e, function (e, t) {
            switch (e) {
                case "header":
                    o.prepend(t);
                    break;
                case "footer":
                    r = t,
                        0 === o.find(".wpforms-page-indicator").length ? o.find(".wpforms-submit-container").before(r) : o.find(".wpforms-page-1").append(r);
                    break;
                case "recaptcha":
                    r = t,
                        o.find(".wpforms-recaptcha-container").append(r)
            }
            var r, a;
            wpforms.isModernMarkupEnabled() && (a = o.attr("aria-errormessage") || "",
                o.attr("aria-errormessage", a + ` wpforms-${i}-${e}-error`))
        })
    }
    wpforms.restoreSubmitButton = function (e, t) {
        var r = e.find(".wpforms-submit")
            , a = r.data("submit-text");
        a && r.html(a),
            r.prop("disabled", !1),
            WPFormsUtils.triggerEvent(e, "wpformsFormSubmitButtonRestore", [e, r]),
            t.css("opacity", ""),
            e.find(".wpforms-submit-spinner").hide()
    }
})(jQuery);