/**
 * Alpha Lazyload Js Library
 * 
 * @author     D-THEMES
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      4.14.0
 */
'use strict';

window.theme || (window.theme = {});

(function ($) {

    theme.defaults || (theme.defaults = {});
    theme.defaults.lazyload = {
        effect: 'fadeIn',
        data_attribute: 'lazy',
        data_srcset: 'lazyset',
        effect_speed: 400,
        failure_limit: 1000,
        event: 'scroll update_lazyload',
        load: function () {
            var $this = $(this);
            if ('IMG' == this.tagName) {
                $this.css('padding-top', '');
                $this.removeClass('d-lazyload');
            } else {
                if (this.classList.contains('elementor-element-populated') || this.classList.contains('elementor-section')) {
                    $this.css('background-image', '');
                }
            }
            $this.removeAttr('data-lazy data-lazyset data-sizes');
            if ($this.closest('.icomp-container').length) {
                if (typeof theme.imageCompare != 'undefined') {
                    theme.imageCompare($this.closest('.icomp-container'));
                }
            }
        }
    };

    /**
     * LazyLoad
     *
     * @since 1.0
     * @param {jQuery|string} selector
     * @return {void}
     */
    theme.lazyload = function (selector) {
        if (typeof selector == 'undefined') {
            $.fn.lazyload && $('[data-lazy]').lazyload(theme.defaults.lazyload);
        } else {
            $.fn.lazyload && $(selector).find('[data-lazy]').lazyload(theme.defaults.lazyload);
        }
    }

    /**
     * Alpha Theme Setup
     */
    $(window).on('load', function () {
        // Run skeleton and init
        if ($.fn.imagesLoaded && typeof theme.skeleton === 'function') {
            if (alpha_vars.resource_after_load && alpha_vars.resource_split_tasks) {
                setTimeout(function () {
                    theme.skeleton($('.skeleton-body'), theme.lazyload);
                })
            } else {
                theme.skeleton($('.skeleton-body'), theme.lazyload);
            }
        } else {
            if (alpha_vars.resource_after_load && alpha_vars.resource_split_tasks) {
                setTimeout(function () {
                    theme.lazyload();
                })
            } else {
                theme.lazyload();
            }
        }
    })
})(jQuery);