/**
 * Alpha Browser Config JS Library
 * 
 * @author     D-THEMES
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      1.0
 * @version    1.0
 */
'use strict';

window.theme || (window.theme = {});

var unknown = '-';

// browser
var nAgt = navigator.userAgent;
var browser = navigator.appName;
var nameOffset, verOffset, ix;

// Opera
if ((verOffset = nAgt.indexOf('Opera')) != -1) {
	browser = 'Opera';
}
// Opera Next
if ((verOffset = nAgt.indexOf('OPR')) != -1) {
	browser = 'Opera';
}
// Legacy Edge
else if ((verOffset = nAgt.indexOf('Edge')) != -1) {
	browser = 'Edge';
}
// Edge (Chromium)
else if ((verOffset = nAgt.indexOf('Edg')) != -1) {
	browser = 'Microsoft Edge';
}
// MSIE
else if ((verOffset = nAgt.indexOf('MSIE')) != -1) {
	browser = 'Internet';
}
// Chrome
else if ((verOffset = nAgt.indexOf('Chrome')) != -1) {
	browser = 'Chrome';
}
// Safari
else if ((verOffset = nAgt.indexOf('Safari')) != -1) {
	browser = 'Safari';
}
// Firefox
else if ((verOffset = nAgt.indexOf('Firefox')) != -1) {
	browser = 'Firefox';
}
// MSIE 11+
else if (nAgt.indexOf('Trident/') != -1) {
	browser = 'Internet';
}
// Other browsers
else if ((nameOffset = nAgt.lastIndexOf(' ') + 1) < (verOffset = nAgt.lastIndexOf('/'))) {
	browser = nAgt.substring(nameOffset, verOffset);
	if (browser.toLowerCase() == browser.toUpperCase()) {
		browser = navigator.appName;
	}
}

// system
var os = unknown;
var clientStrings = [
	{ s: 'Windows 10', r: /(Windows 10.0|Windows NT 10.0)/ },
	{ s: 'Windows 8.1', r: /(Windows 8.1|Windows NT 6.3)/ },
	{ s: 'Windows 8', r: /(Windows 8|Windows NT 6.2)/ },
	{ s: 'Windows 7', r: /(Windows 7|Windows NT 6.1)/ },
	{ s: 'Windows Vista', r: /Windows NT 6.0/ },
	{ s: 'Windows Server 2003', r: /Windows NT 5.2/ },
	{ s: 'Windows XP', r: /(Windows NT 5.1|Windows XP)/ },
	{ s: 'Windows 2000', r: /(Windows NT 5.0|Windows 2000)/ },
	{ s: 'Windows ME', r: /(Win 9x 4.90|Windows ME)/ },
	{ s: 'Windows 98', r: /(Windows 98|Win98)/ },
	{ s: 'Windows 95', r: /(Windows 95|Win95|Windows_95)/ },
	{ s: 'Windows NT 4.0', r: /(Windows NT 4.0|WinNT4.0|WinNT|Windows NT)/ },
	{ s: 'Windows CE', r: /Windows CE/ },
	{ s: 'Windows 3.11', r: /Win16/ },
	{ s: 'Android', r: /Android/ },
	{ s: 'Open BSD', r: /OpenBSD/ },
	{ s: 'Sun OS', r: /SunOS/ },
	{ s: 'Chrome OS', r: /CrOS/ },
	{ s: 'Linux', r: /(Linux|X11(?!.*CrOS))/ },
	{ s: 'iOS', r: /(iPhone|iPad|iPod)/ },
	{ s: 'Mac OS X', r: /Mac OS X/ },
	{ s: 'Mac OS', r: /(Mac OS|MacPPC|MacIntel|Mac_PowerPC|Macintosh)/ },
	{ s: 'QNX', r: /QNX/ },
	{ s: 'UNIX', r: /UNIX/ },
	{ s: 'BeOS', r: /BeOS/ },
	{ s: 'OS/2', r: /OS\/2/ },
	{ s: 'Search Bot', r: /(nuhk|Googlebot|Yammybot|Openbot|Slurp|MSNBot|Ask Jeeves\/Teoma|ia_archiver)/ }
];
for (var id in clientStrings) {
	var cs = clientStrings[id];
	if (cs.r.test(nAgt)) {
		os = cs.s;
		break;
	}
}

if (/Windows/.test(os)) {
	os = 'Windows';
}

/**
 * Detect Internet Explorer
 * 
 * @var {boolean} isIE
 * @since 1.0
 */
theme.isIE = 'Internet' == browser;

/**
 * Detect Edge
 * 
 * @var {boolean} isEdge
 * @since 1.0
 */
theme.isEdge = browser.indexOf("Edge") >= 0;

/**
 * Detect Browser
 * 
 * @var {boolean} isEdge
 * @since 1.0
 */
theme.browser = browser;

/**
 * Detect Mobile
 * 
 * @var {boolean} isMobile
 * @since 1.0
 */
theme.isMobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(nAgt);

/**
 * Detect Os
 * 
 * @var {boolean} isEdge
 * @since 1.0
 */
theme.os = os;

/**
 * Request timeout by using requestAnimationFrame
 * 
 * @since 1.0
 * @param {function} fn
 * @param {number} delay
 * @return {Object} handle
 */
theme.requestTimeout = function (fn, delay) {
	var handler = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame;
	if (!handler) {
		return setTimeout(fn, delay);
	}
	delay || (delay = 0);
	var start, rt = new Object();

	function loop(timestamp) {
		if (!start) {
			start = timestamp;
		}
		var progress = timestamp - start;
		progress >= delay ? fn() : rt.val = handler(loop);
	};

	rt.val = handler(loop);
	return rt;
}

/**
 * Request frame by using requestAnimationFrame
 * 
 * @since 1.0
 * @param {function} fn
 * @return {Object} handle
 */
theme.requestFrame = function (fn) {
	return { val: (window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame)(fn) };
}

/**
 * Request interval by using requestAnimationFrame
 *
 * @since 1.0
 * @param {function} fn
 * @param {number} step
 * @param {number} timeOut
 * @return {Object} handle
 */
theme.requestInterval = function (fn, step, timeOut) {
	var handler = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame;
	if (!handler) {
		if (!timeOut)
			return setTimeout(fn, timeOut);
		else
			return setInterval(fn, step);
	}
	var start, last, rt = new Object();
	function loop(timestamp) {
		if (!start) {
			start = last = timestamp;
		}
		var progress = timestamp - start;
		var delta = timestamp - last;
		if (!timeOut || progress < timeOut) {
			if (delta > step) {
				rt.val = handler(loop);
				fn();
				last = timestamp;
			} else {
				rt.val = handler(loop);
			}
		} else {
			fn();
		}
	};
	rt.val = handler(loop);
	return rt;
}

/**
 * Delete timeout by using requestAnimationFrame
 * 
 * @since 1.0
 * @param {number} timerID
 * @return {void}
 */
theme.deleteTimeout = function (timerID) {
	if (!timerID) {
		return;
	}
	var handler = window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame;
	if (!handler) {
		return clearTimeout(timerID);
	}
	if (timerID.val) {
		return handler(timerID.val);
	}
}

function debounce(func, threshold, execAsap) {
	var timeout;
	return function debounced() {
		var obj = this, args = arguments;
		function delayed() {
			execAsap || func.apply(obj, args);
			timeout = null;
		}

		if (timeout)
			theme.deleteTimeout(timeout);
		else if (execAsap)
			func.apply(obj, args);

		timeout = theme.requestTimeout(delayed, threshold || 100);
	};
};

/**
 * Alpha Theme Setup
 */
window.addEventListener('load', function () {

	// Os & Browser class
	document.getElementsByTagName('body')[0].classList.add('os-' + theme.os, 'browser-' + theme.browser);

	// Touch is enabled?
	document.getElementsByTagName('html')[0].classList.add('ontouchstart' in document ? 'touchable' : 'untouchable');
})