<?php
/**
 * Render template for scroll navigation widget.
 *
 * This template can be overridden by copying it to yourtheme/elementor_templates/widgets/scroll-nav/render-scroll-nav-elementor.php.
 *
 * @author     Andon
 * @package    Alpha Core FrameWork
 * @subpackage Core
 * @since      4.4.0
 */

extract( // @codingStandardsIgnoreLine
	shortcode_atts(
		array(
			'before_hover_text' => '',
			'hover_text'        => esc_html__( 'Hover Here', 'alpha-core' ),
			'after_hover_text'  => '',
			'html_tag'          => 'h2',
			'link'              => array(),
		),
		$atts
	)
);

$this->add_render_attribute( 'wrapper', 'class', 'text-hover-image-wrapper' );

if ( ! empty( $link['url'] ) ) {
	$this->add_link_attributes( 'url', $link );
}
?>
<div <?php $this->print_render_attribute_string( 'wrapper' ); ?>>
	<?php
	if ( ! empty( $link['url'] ) ) {
		?>
		<a <?php $this->print_render_attribute_string( 'url' ); ?>>
		<?php
	}

	$this->add_render_attribute( 'before_hover_text', 'class', 'before-text' );
	$this->add_inline_editing_attributes( 'before_hover_text' );

	$this->add_render_attribute( 'after_hover_text', 'class', 'after-text' );
	$this->add_inline_editing_attributes( 'after_hover_text' );

	$this->add_render_attribute( 'hover_text', 'class', 'text-hover-image' );

	?>
	<<?php Elementor\Utils::print_validated_html_tag( $html_tag ); ?> class="title">
		<?php if ( $before_hover_text || alpha_is_elementor_preview() ) : ?>
		<span <?php $this->print_render_attribute_string( 'before_hover_text' ); ?>><?php $this->print_unescaped_setting( 'before_hover_text' ); ?></span>
		<?php endif; ?>
		<span <?php $this->print_render_attribute_string( 'hover_text' ); ?>>
			<?php $this->print_unescaped_setting( 'hover_text' ); ?>
			<?php if ( $atts['image']['id'] ) : ?>
			<span class="hover-image"><?php echo wp_get_attachment_image( $atts['image']['id'], 'full' ); ?></span>
			<?php endif; ?>
		</span>
		<?php if ( $after_hover_text || alpha_is_elementor_preview() ) : ?>
		<span <?php $this->print_render_attribute_string( 'after_hover_text' ); ?>><?php $this->print_unescaped_setting( 'after_hover_text' ); ?></span>
		<?php endif; ?>
	</<?php Elementor\Utils::print_validated_html_tag( $html_tag ); ?>>

	<?php
	if ( ! empty( $link['url'] ) ) {
		?>
		</a>
		<?php
	}
	?>
</div>
<?php
