<?php
/**
 * Alpha WPForm Addon Class
 *
 *
 * @author     Andon
 * @package    Alpha Core FrameWork
 * @subpackage Core
 * @since      4.0
 * @version    4.0
 */

defined( 'ABSPATH' ) || die;

use Elementor\Controls_Manager;
use Elementor\Alpha_Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;

class Alpha_Core_WPForms extends Alpha_Base {

	/**
	 * Constructor
	 *
	 * @since 4.0
	 */
	public function __construct() {

		// Wpforms default options
		// add_filter( 'wpforms_get_render_engine', array( $this, 'default_wpform_render_engine' ) );

		// Elementor controls
		if ( defined( 'ELEMENTOR_VERSION' ) ) {
			add_action( 'elementor/frontend/widget/before_render', array( $this, 'extend_elementor_widget_render' ) );
			if ( alpha_is_elementor_preview() ) {
				add_action( 'elementor/widget/before_render_content', array( $this, 'extend_elementor_widget_preview' ) );
			}
		}

		add_action( 'elementor/widgets/register', array( $this, 'unregister_widget' ), 20 );

		// Submit button
		add_action( 'wpforms_display_submit_before', array( $this, 'print_custom_submit_button' ) );

		// Replace shortcode
		require_once alpha_core_framework_path( ALPHA_CORE_FRAMEWORK_PATH . '/plugins/wpforms/class-alpha-core-wpforms-shortcode.php' );
	}

	// public function default_wpform_render_engine() {
	// 	return 'classic';
	// }

	/**
	 * Add controls classes for frontend
	 *
	 * @since 4.0
	 */
	public function extend_elementor_widget_render( $self ) {

		if ( 'wpforms' == $self->get_name() ) {

			$settings = $self->get_settings_for_display();

			if ( ! empty( $settings['control_rounded'] ) ) {
				$self->add_render_attribute(
					array(
						'_wrapper' => array(
							'class' => 'controls-' . $settings['control_rounded'],
						),
					)
				);
			}

			if ( ! empty( $settings['control_size'] ) ) {
				$self->add_render_attribute(
					array(
						'_wrapper' => array(
							'class' => 'controls-' . $settings['control_size'],
						),
					)
				);
			}

			if ( ! empty( $settings['label_floating'] ) ) {
				$self->add_render_attribute(
					array(
						'_wrapper' => array(
							'class' => 'label-floating',
						),
					)
				);
			}
		}
	}

	/**
	 * Add controls classes for preview.
	 *
	 * @since 4.0
	 */
	public function extend_elementor_widget_preview( $self ) {
		if ( 'wpforms' == $self->get_name() ) {
			$settings = $self->get_settings_for_display();

			if ( 'elementor/widget/before_render_content' ) {
				echo '<div class="d-none alpha-elementor-widget-options" data-options="' . esc_attr(
					json_encode(
						array(
							'rounded'        => $settings['control_rounded'],
							'size'           => $settings['control_size'],
							'label_floating' => $settings['label_floating'],
						)
					)
				) . '"></div>';
			}
		}
	}

	public function unregister_widget( $self ) {
		$self->unregister( 'wpforms' );

		require_once alpha_core_framework_path( ALPHA_CORE_FRAMEWORK_PATH . '/plugins/wpforms/widget-wpforms-elementor.php' );
		$class_name = 'Alpha_Wpforms_Elementor_Widget';
		$self->register( new $class_name( array(), array( 'widget_name' => 'wpforms' ) ) );
	}

	public function print_custom_submit_button( $form_data ) {

		$form_id     = absint( $form_data['id'] );
		$settings    = $form_data['settings'];
		$el_settings = isset( $form_data['el_settings'] ) ? $form_data['el_settings'] : array();

		/**
		 * Filter form submit button text.
		 *
		 * @since 1.0.0
		 *
		 * @param string $submit_text Submit button text.
		 * @param array  $form_data   Form data.
		 */
		$submit = apply_filters( 'wpforms_field_submit', $settings['submit_text'], $form_data ); // phpcs:ignore WPForms.PHP.ValidateHooks.InvalidHookName

		$submit = sprintf( '<span %1$s>%2$s</span>', ! empty( $el_settings['text_hover_effect'] ) ? ' data-text="' . esc_attr( $submit ) . '"' : '', esc_html( $submit ) );

		if ( isset( $el_settings['icon']['library'] ) && 'svg' == $el_settings['icon']['library'] ) {
			ob_start();
			\ELEMENTOR\Icons_Manager::render_icon(
				array(
					'library' => 'svg',
					'value'   => array( 'id' => absint( isset( $el_settings['icon']['value']['id'] ) ? $el_settings['icon']['value']['id'] : 0 ) ),
				),
				array( 'aria-hidden' => 'true' )
			);
			$svg = ob_get_clean();
		}
		if ( isset( $el_settings['icon'] ) && is_array( $el_settings['icon'] ) && $el_settings['icon']['value'] ) {
			if ( 'before' == $el_settings['icon_pos'] ) {
				if ( isset( $svg ) ) {
					$submit = ( isset( $el_settings['show_label'] ) && 'yes' === $el_settings['show_label'] ) ? $svg . $submit : $svg;
				} else {
					$submit = ( isset( $el_settings['show_label'] ) && 'yes' === $el_settings['show_label'] ) ? '<i class="' . $el_settings['icon']['value'] . '"></i>' . $submit : '<i class="' . $el_settings['icon']['value'] . '"></i>';
				}
			} else {
				if ( isset( $svg ) ) {
					$submit = ( isset( $el_settings['show_label'] ) && 'yes' === $el_settings['show_label'] ) ? $submit . $svg : $svg;
				} else {
					$submit = ( isset( $el_settings['show_label'] ) && 'yes' === $el_settings['show_label'] ) ? $submit . '<i class="' . $el_settings['icon']['value'] . '"></i>' : '<i class="' . $el_settings['icon']['value'] . '"></i>';
				}
			}
		}

		$attrs      = [
			'aria-live' => 'assertive',
			'value'     => 'wpforms-submit',
		];
		$data_attrs = [];

		/**
		 * Filter form submit button classes.
		 *
		 * @since 1.7.5.3
		 *
		 * @param array $classes   Button classes.
		 * @param array $form_data Form data.
		 */
		$classes = (array) apply_filters( 'wpforms_frontend_foot_submit_classes', [], $form_data );

		// A lot of our frontend logic is dependent on this class, so we need to make sure it's present.
		$classes = array_merge( $classes, [ 'wpforms-submit', 'btn' ], alpha_widget_button_get_class( $el_settings ) );

		// Check for submit button alt-text.
		if ( ! empty( $settings['submit_text_processing'] ) ) {
			if ( wpforms_is_amp() ) {
				$attrs['[text]'] = sprintf(
					'%s.submitting ? %s : %s',
					sprintf( 'wpforms_form_state_%d', $form_id ),
					wp_json_encode( $settings['submit_text_processing'], JSON_UNESCAPED_UNICODE ),
					wp_json_encode( $submit, JSON_UNESCAPED_UNICODE )
				);
			} else {
				$data_attrs['alt-text']    = $settings['submit_text_processing'];
				$data_attrs['submit-text'] = $submit;
			}
		}

		// Check user defined submit button classes.
		if ( ! empty( $settings['submit_class'] ) ) {
			$submit_classes = is_array( $settings['submit_class'] ) ?
				$settings['submit_class'] :
				array_filter( explode( ' ', $settings['submit_class'] ) );
			$classes        = array_merge( $classes, $submit_classes );
		}

		printf(
			'<button type="submit" name="wpforms[submit]" %s>%s</button>',
			wpforms_html_attributes(
				// sprintf( 'wpforms-submit-%d', absint( $form_id ) ),
				'',
				$classes,
				$data_attrs,
				$attrs
			),
			$submit
		);
	}
}

/**
 * Create instance
 */
Alpha_Core_WPForms::get_instance();
