/**
 * Alpha Elementor Gsap Functions
 * 
 * @author     D-THEMES
 * @package    WP Alpha Core FrameWork
 * @subpackage Core
 * @since      4.14.0
 * 
 */
'use strict';

window.theme = window.theme || {};

(function ($) {
    $(window).on('elementor/frontend/init', function () {
        if (elementorFrontend && elementorModules.frontend) {
            var appearAnim = elementorModules.frontend.handlers.Base.extend({
                bindEvents: function () {
                    this.run()
                },
                run: function () {
                    this.call_img_reveal();
                },
                call_img_reveal: function () {
                    var anim = this.getElementSettings('_animation');
                    if ('undefined' == typeof anim) {
                        anim = this.$element.attr('data-rocket-animation');
                    }
                    if (this.$element.hasClass('elementor-widget-image')) {
                        if ('undefined' != typeof anim && -1 !== anim.indexOf('scaleReveal')) {
                            var self = this,
                                $img = self.findElement("img"),
                                $wrapper = self.$element,
                                duration = 2,
                                delay = self.getElementSettings('_animation_delay');

                            if ($wrapper.hasClass('animated-fast')) {
                                duration = 1.5;
                            } else if ($wrapper.hasClass('animated-slow')) {
                                duration = 2.5;
                            }

                            if ($img.parent().hasClass('elementor-widget')) {
                                $img.wrap('<div class="elementor-widget-container"></div>');
                            }

                            if ($wrapper.hasClass('animated')) {
                                self.do_img_reveal($img, $wrapper, duration, anim);
                            } else {
                                theme.appear($wrapper.get(0), function () {
                                    setTimeout(function () {
                                        self.do_img_reveal($img, $wrapper, duration, anim);
                                    }, delay);
                                });
                            }
                        }
                    } else if (this.$element.hasClass('elementor-widget-' + alpha_vars.theme + '_widget_posts_grid')) {
                        var self = this,
                            $wrapper = self.$element,
                            settings = $wrapper.find('.repeater-animate').attr('data-settings');

                        if ('undefined' != typeof settings) {
                            settings = JSON.parse(settings);
                            var anim = settings._animation;
                        }

                        if ('undefined' != typeof anim && -1 !== anim.indexOf('scaleReveal')) {
                            $wrapper.find('.repeater-animate').each(function () {
                                var $grid_item = $(this),
                                    $img = $grid_item.find('.alpha-tb-featured-image img'),
                                    duration = 2;

                                settings = $grid_item.attr('data-settings');
                                if ('undefined' != typeof settings) {
                                    settings = JSON.parse(settings);
                                    var anim = settings._animation,
                                        delay = settings._animation_delay;
                                }

                                if ($grid_item.hasClass('animated-fast')) {
                                    duration = 1.5;
                                } else if ($grid_item.hasClass('animated-slow')) {
                                    duration = 2.5;
                                }

                                if ($grid_item.hasClass('animated')) {
                                    self.do_img_reveal($img, $grid_item, duration, anim);
                                } else {
                                    theme.appear($grid_item.get(0), function () {
                                        $grid_item.addClass('appear-animation-visible');
                                        setTimeout(function () {
                                            self.do_img_reveal($img, $grid_item, duration, anim);
                                        }, delay);
                                    });
                                }
                            })
                        }
                    }
                },
                do_img_reveal: function ($img, $wrapper, duration, anim) {
                    var $parent = $img.parent();
                    $wrapper.addClass('animated gsap-animated').removeClass('elementor-invisible');

                    $wrapper.css("overflow", "hidden");
                    $parent.css({
                        overflow: "hidden",
                        display: "block",
                        visibility: "hidden",
                        transition: "none"
                    });

                    var from = {},
                        to = {},
                        easing = 'power2.out';
                    if ('scaleRevealInDown' == anim) {
                        from = {
                            yPercent: -100,
                            ease: easing,
                        };
                        to = {
                            yPercent: 100,
                            scale: 1.3,
                            delay: -duration,
                            ease: easing
                        }
                    } else if ('scaleRevealInUp' == anim) {
                        from = {
                            yPercent: 100,
                            ease: easing,
                        };
                        to = {
                            yPercent: -100,
                            scale: 1.3,
                            delay: -duration,
                            ease: easing
                        }
                    } else if ('scaleRevealInLeft' == anim) {
                        from = {
                            xPercent: -100,
                            ease: easing,
                        };
                        to = {
                            xPercent: 100,
                            scale: 1.3,
                            delay: -duration,
                            ease: easing
                        }
                    } else if ('scaleRevealInRight' == anim) {
                        from = {
                            xPercent: 100,
                            ease: easing,
                        };
                        to = {
                            xPercent: -100,
                            scale: 1.3,
                            delay: -duration,
                            ease: easing
                        }
                    }

                    $parent.each((function () {
                        var $img = $(this).find("img"),
                            _gsap_img = gsap.timeline({
                                scrollTrigger: {
                                    trigger: $(this),
                                    start: "top 50%"
                                }
                            });

                        $img.css('transition', 'none');

                        _gsap_img.set(
                            $(this),
                            { autoAlpha: 1 }
                        );
                        from.onComplete = function () {
                            setTimeout(function () {
                                $img.css('transition', '');
                                $img.css('transform', '');
                            })
                        }
                        _gsap_img.from(
                            $(this),
                            duration,
                            from
                        );
                        _gsap_img.from(
                            $img,
                            duration,
                            to
                        )
                    }))
                }
            });

            elementorFrontend.hooks.addAction('frontend/element_ready/widget', (function (el) {
                elementorFrontend.elementsHandler.addHandler(appearAnim, {
                    $element: el
                })
            }))

            // For Elementor Preview
            if ('undefined' != typeof elementor) {
                elementor.channels.editor.on('change:image', function (childView, editedElement) {
                    if (childView.el.classList.contains('elementor-control-_animation') || childView.el.classList.contains('elementor-control-animation_duration')) {
                        elementorFrontend.elementsHandler.addHandler(appearAnim, {
                            $element: editedElement.$el
                        })
                    }
                })
            }
        }
    })
})(jQuery);