<?php
/**
 * Alpha Elementor Single Product Attribuge Guide Buttons
 *
 * @author     D-THEMES
 * @package    Alpha Core Framework
 * @subpackage Core
 * @since      1.2.0
 */
defined( 'ABSPATH' ) || die;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Color;
use Elementor\Group_Control_Typography;

class Alpha_Single_Product_Attr_Guide_Elementor_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return ALPHA_NAME . '_sproduct_attr_guide';
	}

	public function get_title() {
		return esc_html__( 'Attribute Guides', 'alpha-core' );
	}

	public function get_icon() {
		return 'alpha-elementor-widget-icon u-icon-square';
	}

	public function get_categories() {
		return array( 'alpha_single_product_widget' );
	}

	public function get_keywords() {
		return array( 'single', 'custom', 'layout', 'product', 'woocommerce', 'size', 'chart', 'guide', 'size guide' );
	}

	protected function register_controls() {
		$right = is_rtl() ? 'left' : 'right';

		$this->start_controls_section(
			'section_product_guides',
			array(
				'label' => esc_html__( 'Attribute Guide Buttons', 'alpha-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

			$this->add_control(
				'notice_attr_layout',
				array(
					'type'            => Controls_Manager::RAW_HTML,
					'raw'             => sprintf( __( 'You can change guide content display layout in %1$stheme option%2$s.', 'alpha-core' ), '<a href="' . esc_url( admin_url( 'customize.php?#attr_guide' ) ) . '" target="_blank">', '</a>' ),
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				)
			);

			$this->add_control(
				'attrs_layout',
				array(
					'label'       => esc_html__( 'Direction', 'alpha-core' ),
					'description' => esc_html__( 'Choose show direction of guide buttons when 2 or more attribute guides exist.', 'alpha-core' ),
					'type'        => Controls_Manager::CHOOSE,
					'default'     => 'block',
					'toggle'      => false,
					'options'     => array(
						'flex'  => array(
							'title' => esc_html__( 'Vertical', 'alpha-core' ),
							'icon'  => 'eicon-arrow-down',
						),
						'block' => array(
							'title' => esc_html__( 'Horizontal', 'alpha-core' ),
							'icon'  => 'eicon-arrow-' . $right,
						),
					),
					'render_type' => 'template',
					'selectors'   => array(
						'.elementor-element-{{ID}} .elementor-widget-container' => 'display: {{VALUE}};',
					),
				)
			);

			$this->add_responsive_control(
				'guide_spacing',
				array(
					'label'       => esc_html__( 'Space Between (px)', 'alpha-core' ),
					'description' => esc_html__( 'Control spacings between guide buttons when 2 or more attribute guides exist.', 'alpha-core' ),
					'type'        => Controls_Manager::SLIDER,
					'range'       => array(
						'px'  => array(
							'min' => 0,
							'max' => 100,
						),
						'rem' => array(
							'min' => 0,
							'max' => 10,
						),
						'em'  => array(
							'min' => 0,
							'max' => 10,
						),
					),
					'selectors'   => array(
						'{{WRAPPER}} .guide-link' => '--alpha-product-guide-space-between: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'link_typography',
					'selector' => '{{WRAPPER}} .guide-link',
				)
			);

			$this->add_control(
				'link_color',
				array(
					'label'     => esc_html__( 'Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .guide-link' => 'color: {{VALUE}}',
					),
				)
			);

			$this->add_control(
				'link_color_hover',
				array(
					'label'     => esc_html__( 'Hover Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .guide-link:hover' => 'color: {{VALUE}}',
					),
				)
			);

		$this->end_controls_section();
	}

	protected function render() {
		/**
		 * Filters post products in single product builder.
		 *
		 * @since 1.0
		 */
		if ( apply_filters( 'alpha_single_product_builder_set_preview', false ) ) {
			$settings = $this->get_settings_for_display();
			if ( function_exists( 'alpha_single_product_attr_guides' ) ) {
				alpha_single_product_attr_guides( 'flex' == $settings['attrs_layout'] ? 'vertical' : 'horizontal' );
			}
			do_action( 'alpha_single_product_builder_unset_preview' );
		}
	}
}
