<?php
/**
 * Header mobile menu toggle template
 *
 * @author     D-THEMES
 * @package    Alpha Core Framework
 * @subpackage Core
 * @since      1.0
 */

defined( 'ABSPATH' ) || die;

// disable if mobile menu has no any items
if ( ! function_exists( 'alpha_get_option' ) || ! alpha_get_option( 'mobile_menu_items' ) ) {
	return;
}

extract( // @codingStandardsIgnoreLine
	shortcode_atts(
		array(
			'icon_class'       => '',
			'close_icon_class' => '',
			'direction'        => 'start',
			'skin'             => alpha_get_option( 'mobile_menu_skin' ),
			'show_search_form' => true,
		),
		$atts
	)
);

?>
<a href="#" class="mobile-menu-toggle d-lg-none direction-<?php echo esc_attr( $direction ? $direction : 'start' ) . ( 'top' != $direction && ! $show_search_form ? ' hide-search-form' : '' ); ?>" aria-label="<?php esc_attr_e( 'Mobile Menu', 'alpha-core' ); ?>" data-skin="<?php echo esc_attr( $skin ); ?>">
<?php if ( 'top' != $direction || ( $icon_class && ALPHA_ICON_PREFIX . '-icon-hamburger' != $icon_class ) ) : ?>
	<i class="mmenu-show-icon <?php echo esc_attr( $icon_class ? $icon_class : ALPHA_ICON_PREFIX . '-icon-hamburger', 'alpha-core' ); ?>"></i>
	<?php if ( 'top' == $direction ) : ?>
	<i class="mmenu-hide-icon <?php echo esc_attr( $close_icon_class ? $close_icon_class : ALPHA_ICON_PREFIX . '-icon-times-solid', 'alpha-core' ); ?>"></i>
	<?php endif; ?>
<?php else : ?>
	<i class="icon-anim-burger"><span class="mid-line"></span></i>
<?php endif; ?>
</a>
<?php
if ( 'top' == $direction ) {

	wp_enqueue_style( 'alpha-mmenu-top' );

	$mobile_menus      = alpha_get_option( 'mobile_menu_items' );
	$mobile_menus_temp = array();
	foreach ( $mobile_menus as $menu ) {
		if ( empty( $menu ) ) {
			continue;
		}
		$menu_obj = is_numeric( $menu ) ? get_term( $menu, 'nav_menu' ) : get_term_by( 'slug', $menu, 'nav_menu' );
		if ( empty( $menu_obj ) || is_wp_error( $menu_obj ) ) {
			continue;
		}
		$mobile_menus_temp[] = $menu;
	}
	$mobile_menus = $mobile_menus_temp;
	?>
	<div class="nav-wrapper nav-dropdown preload">
		<?php
		if ( ! empty( $mobile_menus ) ) {
			wp_nav_menu(
				array(
					'menu'            => $mobile_menus[0],
					'container'       => 'nav',
					'container_class' => $mobile_menus[0],
					'items_wrap'      => '<ul id="%1$s" class="mobile-menu">%3$s</ul>',
					'walker'          => class_exists( 'Alpha_Walker_Nav_Menu' ) ? new Alpha_Walker_Nav_Menu() : new Walker_Nav_Menu(),
					'theme_location'  => '',
					'hide_megamenu'   => true,
				)
			);
		} elseif ( has_nav_menu( 'main-menu' ) ) {
			wp_nav_menu(
				array(
					'container'       => 'nav',
					'container_class' => '',
					'items_wrap'      => '<ul id="%1$s" class="mobile-menu">%3$s</ul>',
					'walker'          => class_exists( 'Alpha_Walker_Nav_Menu' ) ? new Alpha_Walker_Nav_Menu() : new Walker_Nav_Menu(),
					'theme_location'  => 'main-menu',
					'hide_megamenu'   => true,
				)
			);
		}
		?>
	</div>
	<?php
}
