/**
 * WP Alpha Core Framework
 * Alpha Highlight
 *
 * @package WP Alpha Core Framework
 * @since   1.2.0
 */

window.theme = window.theme || {};

(function ($) {
    theme.scrollEffects = {
        showLogs: false,
        round: 1000,
        elements: [],
        $selector: '',
        init: function (selector) {
            this.$selector = selector ? selector : $('[data-plugin="scrolling"]');

            this._log("init");
            if (this._inited) {
                this._log("Already Inited");
                this._inited = false;
            } else {
                this._setElementsMap();
                this._onScroll(true)
            }
        },
        _inited: !1,
        _properties: ["x", "y", "z", "rotate", "rotateX", "rotateY", "rotateZ", "scale", "perspective", "opacity", "width"],
        _requestAnimationFrame: function () {
            return window.requestAnimationFrame || function (e, t) {
                window.setTimeout(e, 1000 / 60)
            }
        },
        _log: function (e) {
            this.showLogs && console.log("Parallax Scroll / " + e)
        },
        _setElementsMap: function () {
            var elements = new Map;
            this.$selector.each($.proxy(function (e, t) {
                if ($(this).data('options')) {
                    elements.set($(this), true)
                }
            }), this);
            this.elements = elements;
        },
        _onScroll: function (e) {
            var scrollPos = $(document).scrollTop(),
                windowHeight = $(window).height();
            this._log("onScroll " + scrollPos);
            this.elements.forEach($.proxy(function (e, element) {
                var $element = $(element),
                    res = [],
                    updated = false,
                    originStyle = $element.data("style");

                if (originStyle == false) {
                    originStyle = $element.attr("style") || "";
                    $element.data("style", originStyle);
                }
                options = $element.data("options");

                var scrollFrom = Math.max(0, $element.offset().top - windowHeight),
                    scrollTo = scrollFrom + windowHeight,
                    smooth = options.smooth || 20,
                    _scrollPos = Math.max(scrollPos, scrollFrom);

                if (typeof options['from']['scale'] == 'undefined' && typeof options['from']['width'] == 'undefined' && typeof options['from']['opacity'] == 'undefined') {
                    scrollTo += $element.height();
                }

                if (typeof options['from']['width'] != 'undefined') {
                    scrollTo -= windowHeight / 2;
                }

                _scrollPos = Math.min(_scrollPos, scrollTo);

                this._properties.map($.proxy(function (property) {
                    if ('undefined' != typeof options['from'][property]) {
                        var from = parseFloat(options['from'][property]),
                            to = parseFloat(options['to'][property]);

                        var now = from;
                        if (typeof $element.data("_" + property) != 'undefined') {
                            now = parseFloat($element.data("_" + property));
                        }
                        next = (_scrollPos - scrollFrom) / (scrollTo - scrollFrom) * (to - from) + from;

                        final = now + (next - now) / smooth;
                        final = Math.ceil(final * this.round) / this.round;

                        if (final == now && next == to) {
                            final = to;
                        }

                        res[property] = final;

                        if (now != res[property]) {
                            $element.data("_" + property, res[property]);
                            updated = true;
                        }
                    }
                }, this))

                if (updated) {
                    res.scale = res.scale || 1;
                    var style = '',
                        transformStyle = '',
                        extraStyle = '';
                    if (typeof res.x != 'undefined' || typeof res.y != 'undefined' || typeof res.z != 'undefined' || typeof res.rotate != 'undefined' || typeof res.rotateX != 'undefined' || typeof res.rotateY != 'undefined' || typeof res.rotateZ != 'undefined' || typeof res.scale != 'undefined') {
                        transformStyle = "translate3d(" + (res.x || 0) + "px, " + (res.y || 0) + "px, " + (res.z || 0) + "px)" + " " + (res.rotate ? "rotate(" + (res.rotate || 0) + "deg)" : "rotateX(" + (res.rotateX || 0) + "deg) rotateY(" + (res.rotateY || 0) + "deg) rotateZ(" + (res.rotateZ || 0) + "deg)") + " " + ("scale(" + res.scale + ")") + ";"
                        this._log(transformStyle);
                    }
                    if (typeof res.opacity != 'undefined') {
                        extraStyle += 'opacity: ' + res.opacity + ';';
                    }
                    if (typeof res.width != 'undefined') {
                        extraStyle += 'width: ' + res.width + '%;';
                        extraStyle += 'margin: 0 auto';
                    }
                    if (transformStyle) {
                        style += 'transform:' + transformStyle;
                    }
                    if (options['from']['scale'] != 1 || options['to']['scale'] != 1) {
                        style += 'transform-origin:center;';
                    }
                    if (extraStyle) {
                        style += style ? (' ' + extraStyle) : extraStyle;
                    }
                    if (originStyle) {
                        style += style ? (' ' + originStyle) : originStyle;
                    }
                    $element.attr('style', style);
                }
            }, this));
            window.requestAnimationFrame ? window.requestAnimationFrame($.proxy(this._onScroll, this, false)) : this._requestAnimationFrame($.proxy(this._onScroll, this, false));
        }
    }

    /**
     * Initialize advanced motions
     *
     * @since 1.0
     * @param {string} selector
     * @param {string} action
     * @return {void}
     */
    theme.initAdvancedMotions = function (selector, action) {
        if (theme.isMobile) {
            return;
        }

        var $selectors = '';

        if (selector) {
            $selectors = selector;
        } else {
            $selectors = $('[data-plugin="scrolling"]');
        }

        if (action == 'destroy') {
            $selectors.removeAttr('data-plugin data-options');
            $selectors.removeData('options');
            return;
        }

        if ($selectors.length) {
            theme.scrollEffects.init();
        }
    }


    if (window.theme && theme.status == 'complete') {
        theme.initAdvancedMotions(); // Initialize scrolling widgets
    } else {
        $(window).on('alpha_complete', function () {
            theme.initAdvancedMotions(); // Initialize scrolling widgets
        });
    }
})(window.jQuery);
