(function ($) {
    'use strict';
    // Uploading files
    var file_frame;
    var clickedID;

    $(document).off('click', '.btn_upload_img').on('click', '.btn_upload_img', function (event) {

        event.preventDefault();

        // If the media frame already exists, reopen it.
        if (!file_frame) {
            // Create the media frame.
            file_frame = wp.media.frames.downloadable_file = wp.media({
                title: 'Choose an image',
                button: {
                    text: 'Use image'
                },
                multiple: false
            });
        }

        file_frame.open();

        clickedID = $(this).attr('id');

        // When an image is selected, run a callback.
        file_frame.on('select', function () {
            var attachment = file_frame.state().get('selection').first().toJSON();

            $('#' + clickedID).val(attachment.url);
            if ($('#' + clickedID).attr('data-name'))
                $('#' + clickedID).attr('name', $('#' + clickedID).attr('data-name'));

            file_frame.close();
        });
    });

    $(document).on('click', '.btn_remove_img', function (event) {

        var clickedID = $(this).attr('id');
        $('#' + clickedID).val('');
        $('#' + clickedID + '_thumb').html('');

        return false;
    });

    $(document).on('change', '.field-megamenu input[type="checkbox"]', function (event) {
        var $menuItem = $(this).closest('.menu-item');
        var $nextItem = $menuItem.next();
        if ($(this).prop('checked')) {
            $menuItem.addClass('menu-item-megamenu');
            while ($nextItem.length && !$nextItem.hasClass('menu-item-depth-0')) {
                $nextItem.addClass('menu-item-megamenu');
                $nextItem = $nextItem.next();
            }
        } else {
            $menuItem.removeClass('menu-item-megamenu');
            while ($nextItem.length && !$nextItem.hasClass('menu-item-depth-0')) {
                $nextItem.removeClass('menu-item-megamenu');
                $nextItem = $nextItem.next();
            }
        }
    });

    $(document).on('change', '.field-block select', function (event) {
        var $menuItem = $(this).closest('.menu-item'),
            selectedVal = $(this).val();
        if (selectedVal) {
            $menuItem.find('.field-icon_type, .field-icon, .field-icon_svg, .field-label_name').hide();
        } else {
            $menuItem.find('.field-icon_type, .field-label_name').show();
            $menuItem.find('.field-icon_type select').trigger('change');
        }
    });

    $(document).on('change', '.field-icon_type select', function (event) {
        var $menuItem = $(this).closest('.menu-item'),
            selectedVal = $(this).val();
        if ('svg' == selectedVal) {
            $menuItem.find('.field-icon').hide();
            $menuItem.find('.field-icon_svg').show();
        } else {
            $menuItem.find('.field-icon').show();
            $menuItem.find('.field-icon_svg').hide();
        }
    });

    $(document).on('ready', function () {
        $('.field-megamenu input[type="checkbox"]').each(function () {
            if ($(this).prop('checked')) {
                var $menuItem = $(this).closest('.menu-item');
                var $nextItem = $menuItem.next();
                $menuItem.addClass('menu-item-megamenu');
                while ($nextItem.length && !$nextItem.hasClass('menu-item-depth-0')) {
                    $nextItem.addClass('menu-item-megamenu');
                    $nextItem = $nextItem.next();
                }
            }
        })

        $('.field-block select').each(function () {
            var $menuItem = $(this).closest('.menu-item'),
                selectedVal = $(this).val();
            if (selectedVal) {
                $menuItem.find('.field-icon_type, .field-icon, .field-icon_svg, .field-label_name').hide();
            }
        })

        $('.field-icon_type select').each(function () {
            var $menuItem = $(this).closest('.menu-item'),
                selectedVal = $(this).val();
            if ('svg' == selectedVal) {
                $menuItem.find('.field-icon').hide();
            } else {
                $menuItem.find('.field-icon_svg').hide();
            }
        })
    });
})(jQuery);