<?php

// Direct load is not allowed
if ( ! defined( 'ABSPATH' ) ) {
	die();
}

use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Icons_Manager;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Modules\NestedElements\Base\Widget_Nested_Base;
use Elementor\Modules\NestedElements\Controls\Control_Nested_Repeater;

class Alpus_Nested_Sticky extends Widget_Nested_Base {

	public function get_name() {
		return 'alpus-nested-sticky';
	}

	public function get_title() {
		return esc_html__( 'Alpus Nested Sticky', 'alpus-flexbox' );
	}

	public function get_icon() {
		return 'eicon-import-export';
	}

	public function get_categories() {
		return array( 'layout' );
	}

	public function get_script_depends() {
		return array( 'alpus-el-sticky' );
	}

	public function get_keywords() {
		return array( 'nested', 'sticky column', 'sticky container', 'image' );
	}

	public function has_widget_inner_wrapper(): bool {
		return ! Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}
	
	protected function get_default_children_placeholder_selector() {
		return '.alpus-nested-sticky';
	}

    protected function sticky_item_container( int $index ) {
		return array(
			'elType'   => 'container',
			'settings' => array(
				'_title'        => sprintf( __( 'Item #%s', 'alpus-flexbox' ), $index ),
				'content_width' => 'full',
				'padding'       => array(
					'unit'     => 'px',
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'isLinked' => true,
				),
            ),
        );
	}

	protected function get_default_children_title() {
		return esc_html__( 'Item #%d', 'alpus-flexbox' );
	}

    protected function get_default_repeater_title_setting_key() {
		// return 'slide_title';
		return '';
	}

	protected function get_default_children_elements() {
		return array(
			$this->sticky_item_container( 1 ),
        );
	}

    protected function register_controls() {

		$this->start_controls_section(
			'section_sticky_container',
			array(
				'label'     => esc_html__( 'Sticky Content', 'alpus-flexbox' ),
				'tab'       => Controls_Manager::TAB_LAYOUT,
			)
		);
			$repeater = new Repeater();

			$this->add_control( 
				'items', 
				array(
					'label'   => esc_html__( 'Items', 'alpus-flexbox' ),
					'type'    => Control_Nested_Repeater::CONTROL_TYPE,
					'fields'  => $repeater->get_controls(),
					'default' => array(
						array(),
					),
					'button_text' => esc_html__( 'Add Item', 'alpus-flexbox' ),
				)
			);

			/* start sticky options */
			$this->add_control(
				'container_selector',
				array(
					'label'       => esc_html__( 'Container Selector', 'alpus-flexbox' ),
					'description' => esc_html__( 'Closest parent element which contains sticky and background elements. e.g: .my-class', 'alpus-flexbox' ),
					'type'        => Controls_Manager::TEXT,
				)
			);
			$this->add_control(
				'min_width',
				array(
					'label'     => esc_html__( 'Min Width (unit: px)', 'alpus-flexbox' ),
					'type'      => Controls_Manager::NUMBER,
					'min'       => 320,
					'max'       => 1920,
					'step'      => 1,
					'default'   => 768,
				)
			);
			$this->add_control(
				'offset_top',
				array(
					'label'       => esc_html__( 'Top (unit: px)', 'alpus-flexbox' ),
					'description' => esc_html__( 'Top position when active', 'alpus-flexbox' ),
					'type'        => Controls_Manager::NUMBER,
					'min'         => 0,
					'max'         => 500,
					'step'        => 1,
					'default'     => 110,
				)
			);
			$this->add_control(
				'offset_bottom',
				array(
					'label'       => esc_html__( 'Bottom (unit: px)', 'alpus-flexbox' ),
					'description' => __( 'Bottom position when active', 'alpus-flexbox' ),
					'type'        => Controls_Manager::NUMBER,
					'min'         => 0,
					'max'         => 500,
					'step'        => 1,
					'default'     => 0,
				)
			);
			$this->add_control(
				'active_class',
				array(
					'label'     => esc_html__( 'Active Class', 'alpus-flexbox' ),
					'type'      => Controls_Manager::TEXT,
				)
			);
			$this->add_control(
				'autofit',
				array(
					'label'     => esc_html__( 'Auto Fit', 'alpus-flexbox' ),
					'type'      => Controls_Manager::SWITCHER,
				)
			);
			/* end sticky options */

		$this->end_controls_section();
		
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
		if ( empty( $settings['items'] ) ) {
			return;
		}

		$items_html = '';
		foreach ( $settings['items'] as $index => $slide ) {
			// Slide Content.
			ob_start();
			$this->print_child( $index );
			$item_html = ob_get_clean();
			$items_html .= $item_html;
		}


		$options                      = array();
		$options['containerSelector'] = ! empty( $settings['container_selector'] ) ? $settings['container_selector'] : '';
		$options['minWidth']          = ! empty( $settings['min_width'] ) ? (int) $settings['min_width'] : 768;
		$options['padding']           = array();
		$options['padding']['top']    = isset( $settings['offset_top'] ) && '' !== $settings['offset_top'] ? (int) $settings['offset_top'] : 110;
		$options['padding']['bottom'] = ! empty( $settings['offset_bottom'] ) ? (int) $settings['offset_bottom'] : 0;
		$options['activeClass']       = ! empty( $settings['active_class'] ) ? esc_attr( $settings['active_class'] ) : 'sticky-active';
		if ( ! empty( $settings['autofit'] ) ) {
			$options['autoFit'] = true;
		}
		$options      = json_encode( $options );

		?>
		<div class="alpus-nested-sticky" data-plugin-sticky data-plugin-options="<?php echo esc_attr( $options ); ?>">
			<?php echo $items_html;// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		</div>
		<?php
    }

	protected function content_template() {
		?>
		<#
			let extra_options = {}, extra_attr;
			extra_options['containerSelector'] = settings['container_selector'] ? settings['container_selector'] : '';
			extra_options['minWidth']          = settings['min_width'] ? Number( settings['min_width'] ) : 768;
			extra_options['padding']           = {};
			extra_options['padding']['top']    = '' !== settings['offset_top'] ? Number( settings['offset_top'] ) : 110;
			extra_options['padding']['bottom'] = settings['offset_bottom'] ? Number( settings['offset_bottom'] ) : 0;
			extra_options['activeClass']       = settings['active_class'] ? settings['active_class'] : 'sticky-active';
			if ( settings['autofit'] ) {
				extra_options['autoFit'] = true;
			}
			extra_attr = ' data-plugin-options=' + JSON.stringify( extra_options );
		#>
			<div class="alpus-nested-sticky" data-plugin-sticky{{{ extra_attr }}}>
			</div>
		<?php
	}
}
